<?php
session_start();

// Configuration
$passwordProtect = true;
$correctPasswordHash = '$2a$12$wMwpjdVF1koCjqvlTKPlGeZ1aiJjnroho58ICR9FC18nWsUFQh3Lq'; // Replace with your bcrypt hash
$remoteFetchAllowed = true;

// Security check for password protection
if ($passwordProtect) {
    if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
        if (isset($_POST['password'])) {
            if (password_verify($_POST['password'], $correctPasswordHash)) {
                $_SESSION['loggedin'] = true;
            } else {
                die('
                <!DOCTYPE html>
                <html lang="en">
                <head>
                    <meta charset="UTF-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0">
                    <title>Access Denied</title>
                    <script src="https://cdn.tailwindcss.com"></script>
                </head>
                <body class="bg-gray-100 h-screen flex items-center justify-center">
                    <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-md">
                        <h2 class="text-2xl font-bold mb-6 text-center">Password Required</h2>
                        <form method="POST">
                            <input type="password" name="password" class="w-full p-2 border rounded mb-4" placeholder="Enter password" required autofocus>
                            <button type="submit" class="w-full bg-blue-500 text-white p-2 rounded hover:bg-blue-600">Submit</button>
                        </form>
                    </div>
                </body>
                </html>
                ');
            }
        } else {
            echo '
            <!DOCTYPE html>
            <html lang="en">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Access Denied</title>
                <script src="https://cdn.tailwindcss.com"></script>
            </head>
            <body class="bg-gray-100 h-screen flex items-center justify-center">
                <div class="bg-white p-8 rounded-lg shadow-md w-full max-w-md">
                    <h2 class="text-2xl font-bold mb-6 text-center">Password Required</h2>
                    <form method="POST">
                        <input type="password" name="password" class="w-full p-2 border rounded mb-4" placeholder="Enter password" required autofocus>
                        <button type="submit" class="w-full bg-blue-500 text-white p-2 rounded hover:bg-blue-600">Submit</button>
                    </form>
                </div>
            </body>
            </html>
            ';
            exit;
        }
    }
}

// Handle file content retrieval for editing
if (isset($_GET['action']) && $_GET['action'] === 'get_file_content' && isset($_GET['file'])) {
    $filePath = realpath($_GET['dir'] . '/' . $_GET['file']);
    if ($filePath && is_file($filePath)) {
        header('Content-Type: text/plain');
        echo file_get_contents($filePath);
        exit;
    } else {
        http_response_code(404);
        echo "File not found.";
        exit;
    }
}

// Handle current directory
$currentDir = isset($_GET['dir']) ? realpath($_GET['dir']) : __DIR__;
if (!$currentDir) {
    $currentDir = __DIR__;
}

// File operations
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Create folder
    if (isset($_POST['create_folder'])) {
        $folderName = sanitizeFileName($_POST['folder_name']);
        $newFolderPath = $currentDir . '/' . $folderName;
        if (!is_dir($newFolderPath)) {
            mkdir($newFolderPath, 0755);
            $message = "Folder created successfully.";
        } else {
            $message = "Folder already exists.";
        }
    }

    // Create file
    if (isset($_POST['create_file'])) {
        $fileName = sanitizeFileName($_POST['file_name']);
        $fileContent = $_POST['file_content'];
        $newFilePath = $currentDir . '/' . $fileName;
        file_put_contents($newFilePath, $fileContent);
        $message = "File created successfully.";
    }

    // Upload file
    if (isset($_FILES['upload_file'])) {
        $uploadedFile = $_FILES['upload_file'];
        $destination = $currentDir . '/' . sanitizeFileName($uploadedFile['name']);
        if (move_uploaded_file($uploadedFile['tmp_name'], $destination)) {
            $message = "File uploaded successfully.";
        } else {
            $message = "Error uploading file.";
        }
    }

    // Rename item
    if (isset($_POST['rename_item'])) {
        $oldName = sanitizeFileName($_POST['old_name']);
        $newName = sanitizeFileName($_POST['new_name']);
        if (rename($currentDir . '/' . $oldName, $currentDir . '/' . $newName)) {
            $message = "Item renamed successfully.";
        } else {
            $messageFi = "Error renaming item.";
        }
    }

    // Delete item
    if (isset($_POST['delete_item'])) {
        $itemName = sanitizeFileName($_POST['item_name']);
        $itemPath = $currentDir . '/' . $itemName;
        if (is_dir($itemPath)) {
            rmdir($itemPath);
            $message = "Folder deleted successfully.";
        } elseif (is_file($itemPath)) {
            unlink($itemPath);
            $message = "File deleted successfully.";
        } else {
            $message = "Item not found.";
        }
    }

    // Unzip file
    if (isset($_POST['unzip_file'])) {
        $zipFile = sanitizeFileName($_POST['zip_file']);
        $zip = new ZipArchive;
        if ($zip->open($currentDir . '/' . $zipFile) === TRUE) {
            $zip->extractTo($currentDir);
            $zip->close();
            $message = "ZIP file extracted successfully.";
        } else {
            $message = "Error extracting ZIP file.";
        }
    }

    // Fetch remote file
    if ($remoteFetchAllowed && isset($_POST['fetch_remote_file'])) {
        $remoteUrl = filter_var($_POST['remote_url'], FILTER_VALIDATE_URL);
        if ($remoteUrl) {
            $fileName = sanitizeFileName(basename($remoteUrl));
            $localPath = $currentDir . '/' . $fileName;
            if (file_put_contents($localPath, file_get_contents($remoteUrl))) {
                $message = "File downloaded successfully.";
            } else {
                $message = "Error downloading file.";
            }
        } else {
            $message = "Invalid URL.";
        }
    }

    // Edit file
    if (isset($_POST['edit_file'])) {
        $fileName = sanitizeFileName($_POST['file_name']);
        $fileContent = $_POST['file_content'];
        $filePath = $currentDir . '/' . $fileName;
        if (file_put_contents($filePath, $fileContent) !== false) {
            $message = "File edited successfully.";
        } else {
            $message = "Error editing file.";
        }
    }
}

// List directory contents
$items = scandir($currentDir);
$directories = [];
$files = [];

foreach ($items as $item) {
    if ($item === '.') continue; // Skip current directory
    $itemPath = $currentDir . '/' . $item;
    if (is_dir($itemPath)) {
        $directories[] = $item;
    } else {
        $files[] = $item;
    }
}
sort($directories);
sort($files);

// Helper functions
function sanitizeFileName($filename) {
    return preg_replace('/[^a-zA-Z0-9._-]/', '', $filename);
}

function formatFileSize($bytes) {
    if ($bytes >= 1073741824) return number_format($bytes / 1073741824, 2) . ' GB';
    if ($bytes >= 1048576) return number_format($bytes / 1048576, 2) . ' MB';
    if ($bytes >= 1024) return number_format($bytes / 1024, 2) . ' KB';
    return $bytes . ' bytes';
}

function generateBreadcrumbs($path) {
    $parts = array_filter(explode(DIRECTORY_SEPARATOR, $path));
    $breadcrumbs = [];
    $cumulativePath = '';

    // Add root
    $breadcrumbs[] = '<a href="?dir=/" class="text-blue-500 hover:underline">Root</a>';

    // Build breadcrumbs
    foreach ($parts as $part) {
        $cumulativePath .= DIRECTORY_SEPARATOR . $part;
        if (realpath($cumulativePath)) {
            $breadcrumbs[] = '<a href="?dir=' . urlencode($cumulativePath) . '" class="text-blue-500 hover:underline">' . htmlspecialchars($part) . '</a>';
        }
    }

    return implode(' / ', $breadcrumbs);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP File Manager</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</head>
<body class="bg-gray-100 min-h-screen">
    <div class="container mx-auto p-4">
        <h1 class="text-3xl font-bold mb-6">PHP File Manager</h1>

        <!-- Breadcrumbs -->
        <nav class="mb-4"><?php echo generateBreadcrumbs($currentDir); ?></nav>

        <!-- Message -->
        <?php if (isset($message)): ?>
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <!-- Action Forms -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <!-- Create Folder -->
            <div class="bg-white p-4 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-2">Create Folder</h3>
                <form method="post" class="flex space-x-2">
                    <input type="text" name="folder_name" class="flex-1 p-2 border rounded" placeholder="Folder name" required>
                    <button type="submit" name="create_folder" class="bg-blue-500 text-white p-2 rounded hover:bg-blue-600">Create</button>
                </form>
            </div>

            <!-- Upload File -->
            <div class="bg-white p-4 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-2">Upload File</h3>
                <form method="post" enctype="multipart/form-data" class="flex space-x-2">
                    <input type="file" name="upload_file" class="flex-1 p-2 border rounded" required>
                    <button type="submit" class="bg-blue-500 text-white p-2 rounded hover:bg-blue-600">Upload</button>
                </form>
            </div>

            <!-- Fetch Remote File -->
            <?php if ($remoteFetchAllowed): ?>
                <div class="bg-white p-4 rounded-lg shadow">
                    <h3 class="text-lg font-semibold mb-2">Fetch Remote File</h3>
                    <form method="post" class="flex space-x-2">
                        <input type="url" name="remote_url" class="flex-1 p-2 border rounded" placeholder="https://example.com/file.zip" required>
                        <button type="submit" name="fetch_remote_file" class="bg-blue-500 text-white p-2 rounded hover:bg-blue-600">Fetch</button>
                    </form>
                </div>
            <?php endif; ?>
        </div>

        <!-- File/Folder List -->
        <div class="bg-white rounded-lg shadow overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="p-3 text-left">Name</th>
                        <th class="p-3 text-left">Size</th>
                        <th class="p-3 text-left">Writable</th>
                        <th class="p-3 text-left">Last Modified</th>
                        <th class="p-3 text-left">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Parent Directory -->
                    <?php if ($currentDir !== DIRECTORY_SEPARATOR): ?>
                        <tr class="border-t">
                            <td class="p-3"><i class="fas fa-folder mr-2"></i><a href="?dir=<?php echo urlencode(dirname($currentDir)); ?>" class="text-blue-500 hover:underline">.. (Parent Directory)</a></td>
                            <td class="p-3">-</td>
                            <td class="p-3">-</td>
                            <td class="p-3">-</td>
                            <td class="p-3"></td>
                        </tr>
                    <?php endif; ?>

                    <!-- Directories -->
                    <?php foreach ($directories as $directory): ?>
                        <?php if ($directory === '..') continue; // Skip '..' as it's handled above ?>
                        <tr class="border-t">
                            <td class="p-3"><i class="fas fa-folder mr-2"></i><a href="?dir=<?php echo urlencode($currentDir . '/' . $directory); ?>" class="text-blue-500 hover:underline"><?php echo htmlspecialchars($directory); ?></a></td>
                            <td class="p-3">-</td>
                            <td class="p-3"><?php echo is_writable($currentDir . '/' . $directory) ? 'Yes' : 'No'; ?></td>
                            <td class="p-3"><?php echo date("Y-m-d H:i:s", filemtime($currentDir . '/' . $directory)); ?></td>
                            <td class="p-3 space-x-2">
                                <button onclick="openRenameModal('<?php echo htmlspecialchars($directory); ?>')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                                <button onclick="deleteItem('<?php echo htmlspecialchars($directory); ?>')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    <!-- Files -->
                    <?php foreach ($files as $file): ?>
                        <tr class="border-t">
                            <td class="p-3"><i class="fas fa-file mr-2"></i><?php echo htmlspecialchars($file); ?></td>
                            <td class="p-3"><?php echo formatFileSize(filesize($currentDir . '/' . $file)); ?></td>
                            <td class="p-3"><?php echo is_writable($currentDir . '/' . $file) ? 'Yes' : 'No'; ?></td>
                            <td class="p-3"><?php echo date("Y-m-d H:i:s", filemtime($currentDir . '/' . $file)); ?></td>
                            <td class="p-3 space-x-2">
                                <button onclick="editFile('<?php echo htmlspecialchars($file); ?>')" class="bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">Edit</button>
                                <button onclick="openRenameModal('<?php echo htmlspecialchars($file); ?>')" class="bg-yellow-500 text-white px-2 py-1 rounded hover:bg-yellow-600">Rename</button>
                                <button onclick="deleteItem('<?php echo htmlspecialchars($file); ?>')" class="bg-red-500 text-white px-2 py-1 rounded hover:bg-red-600">Delete</button>
                                <?php if (pathinfo($file, PATHINFO_EXTENSION) === 'zip'): ?>
                                    <form method="post" class="inline">
                                        <input type="hidden" name="zip_file" value="<?php echo htmlspecialchars($file); ?>">
                                        <button type="submit" name="unzip_file" class="bg-green-500 text-white px-2 py-1 rounded hover:bg-green-600"><i class="fas fa-file-archive mr-1"></i>Unzip</button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Edit Modal -->
    <div id="editModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden items-center justify-center">
        <div class="bg-white p-6 rounded-lg w-full max-w-2xl">
            <h2 class="text-xl font-bold mb-4">Edit File</h2>
            <form id="editForm" method="post">
                <input type="hidden" id="editFileName" name="file_name">
                <textarea id="editFileContent" name="file_content" class="w-full h-64 p-2 border rounded mb-4"></textarea>
                <div class="flex justify-end space-x-2">
                    <button type="submit" name="edit_file" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">Save</button>
                    <button type="button" onclick="closeModal('editModal')" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Rename Modal -->
    <div id="renameModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden items-center justify-center">
        <div class="bg-white p-6 rounded-lg w-full max-w-md">
            <h2 class="text-xl font-bold mb-4">Rename Item</h2>
            <form id="renameForm" method="post">
                <input type="hidden" id="oldItemName" name="old_name">
                <input type="text" id="newItemName" name="new_name" class="w-full p-2 border rounded mb-4" required>
                <div class="flex justify-end space-x-2">
                    <button type="submit" name="rename_item" class="bg-green-500 text-white px-4 py-2 rounded hover:bg-green-600">Save</button>
                    <button type="button" onclick="closeModal('renameModal')" class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function editFile(fileName) {
            fetch('?dir=<?php echo urlencode($currentDir); ?>&action=get_file_content&file=' + encodeURIComponent(fileName))
                .then(response => {
                    if (!response.ok) throw new Error('File not found');
                    return response.text();
                })
                .then(content => {
                    document.getElementById('editFileName').value = fileName;
                    document.getElementById('editFileContent').value = content;
                    openModal('editModal');
                })
                .catch(error => {
                    alert('Error loading file content: ' + error.message);
                });
        }

        function openRenameModal(itemName) {
            document.getElementById('oldItemName').value = itemName;
            document.getElementById('newItemName').value = itemName;
            openModal('renameModal');
        }

        function deleteItem(itemName) {
            if (confirm('Are you sure you want to delete this item?')) {
                const form = document.createElement('form');
                form.method = 'post';
                form.innerHTML = `
                    <input type="hidden" name="item_name" value="${itemName}">
                    <input type="hidden" name="delete_item" value="1">
                `;
                document.body.appendChild(form);
                form.submit();
            }
        }

        function openModal(modalId) {
            document.getElementById(modalId).classList.remove('hidden');
            document.getElementById(modalId).classList.add('flex');
        }

        function closeModal(modalId) {
            document.getElementById(modalId).classList.add('hidden');
            document.getElementById(modalId).classList.remove('flex');
        }
    </script>
</body>
</html>